/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.render.entity;

import java.util.UUID;
import mod.azure.azurelib.common.animation.impl.AzEntityAnimator;
import mod.azure.azurelib.common.model.AzBakedModel;
import mod.azure.azurelib.common.render.AzProvider;
import mod.azure.azurelib.common.render.entity.AzEntityNameRenderUtil;
import mod.azure.azurelib.common.render.entity.AzEntityRendererConfig;
import mod.azure.azurelib.common.render.entity.AzEntityRendererPipeline;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_897;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AzEntityRenderer<T extends class_1297>
extends class_897<T> {
    protected final AzEntityRendererConfig<T> config;
    protected final AzProvider<UUID, T> provider;
    protected final AzEntityRendererPipeline<T> rendererPipeline;
    @Nullable
    private AzEntityAnimator<T> reusedAzEntityAnimator;

    protected AzEntityRenderer(AzEntityRendererConfig<T> config, class_5617.class_5618 context) {
        super(context);
        this.config = config;
        this.provider = new AzProvider<UUID, class_1297>(config::createAnimator, config::modelLocation, class_1297::method_5667);
        this.rendererPipeline = this.createPipeline(config);
    }

    public AzEntityRendererPipeline<T> createPipeline(AzEntityRendererConfig<T> config) {
        return new AzEntityRendererPipeline<T>(config, this);
    }

    @NotNull
    public class_2960 method_3931(@NotNull T animatable) {
        return this.config.textureLocation((class_1297)animatable, animatable);
    }

    public void superRender(@NotNull T entity, float entityYaw, float partialTick, @NotNull class_4587 poseStack, @NotNull class_4597 bufferSource, int packedLight) {
        super.method_3936(entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    public void method_3936(@NotNull T entity, float entityYaw, float partialTick, @NotNull class_4587 poseStack, @NotNull class_4597 bufferSource, int packedLight) {
        AzEntityAnimator cachedEntityAnimator = (AzEntityAnimator)this.provider.provideAnimator((class_1297)entity, entity);
        AzBakedModel azBakedModel = this.provider.provideBakedModel((class_1297)entity, entity);
        this.reusedAzEntityAnimator = cachedEntityAnimator;
        this.rendererPipeline.render(poseStack, azBakedModel, entity, bufferSource, null, null, entityYaw, partialTick, packedLight);
    }

    protected float method_55831(@NotNull T entity) {
        return this.config.shadowRadius(entity);
    }

    public boolean method_3921(@NotNull T entity) {
        return AzEntityNameRenderUtil.shouldShowName(this.field_4676, entity);
    }

    public int method_24087(@NotNull T entity, @NotNull class_2338 pos) {
        return super.method_24087(entity, pos);
    }

    public AzEntityAnimator<T> getAnimator() {
        return this.reusedAzEntityAnimator;
    }

    public AzEntityRendererConfig<T> config() {
        return this.config;
    }
}

